@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4">

        <div class="row mb-3">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h2>Gestion de Tickets</h2>
                        @can('create', App\Models\Ticket::class)
                            <a class="btn btn-info" style="float: right"
                                href="{{ route('Ticket.create', $ticket->dossier->id) }}">Ajouter</a>
                        @endcan

                        <a class="btn btn-primary" href="{{ route('Dossier.show', $ticket->dossier->id) }}">Dossier</a>

                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">

                        <div class="table-responsive">
                            <table class="table" id="">
                                <thead>
                                    <tr>
                                        <th>Dossier</th>
                                        <th>Reclameur</th>
                                        <th>Utilisateur</th>
                                        <th>Status</th>
                                        <th>Date Reponse</th>
                                        <th>Date Creation</th>
                                        <th>Modifier</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><a
                                                href="{{ route('Dossier.show', $ticket->dossier_id) }}">{{ $ticket->dossier->ref }}</a>
                                        </td>
                                        <td>{{ $ticket->creator->name }}</td>
                                        <td>{{ $ticket->user->name }}</td>
                                        <td>
                                            <span
                                                class="badge @switch($ticket->status->id) @case(1)           bg-danger           @break       @case(2)           bg-primary            @break        @default            bg-success @endswitch">{{ $ticket->status->status }}</span>
                                        </td>
                                        <td>{{ $ticket->answer_at }}</td>
                                        <td>{{ $ticket->created_at }}</td>

                                        <td>
                                            @if ($ticket->user_id == Auth::user()->id)
                                                @if ($ticket->status_rendezvous_id == 2)
                                                    <a class="btn btn-sm btn-info rounded-pill"
                                                        href="{{ route('Ticket.edit', [$ticket->id]) }}"><i
                                                            class="uil uil-pen fs-5"></i></a>
                                                @endif
                                            @endif
                                        </td>



                                    </tr>

                                </tbody>
                            </table>
                        </div>


                    </div>
                </div>

            </div>
        </div>
        <div class="row">

            <div class="card">
                <div class="card-body">
                    <div class="col-12">
                        <div class="col-6">
                            <label for="">Reclamation</label>
                            <textarea readonly class="form-control" name="" id="" cols="30" rows="10">
                            {{ $ticket->motif }}
                        </textarea>
                        </div>
                        <div class="col-6 mt-2">
                            <label for="">Reponse</label>
                            <textarea readonly class="form-control" name="" id="" cols="30" rows="10">
                            {{ $ticket->answer }}
                        </textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
