@extends('layouts.dashboard.app')

@section('content')
    <div class="container-fluid mt-4 ">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="d-flex ">

                                @can('viewAny', App\Models\Settlement::class)
                                    <div class="col-md-6">
                                        <a style="float: left" href="{{ route('Settlement.create') }}"
                                            class="btn btn-success rounded-pill"> Créer</a>
                                    </div>
                                @endcan

                                @can('viewAny', App\Models\Settlement::class)
                                    <div class="col-md-6">
                                        <a style="float: right" href="{{ route('Settlement.all') }}"
                                            class="btn btn-warning rounded-pill"> Réglements </a>
                                    </div>
                                @endcan

                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>ICE</th>
                                        <th>Assurance</th>
                                        <th>Afficher</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($companies as $company)
                                        <tr>
                                            <td>{{ $company->ice }}</td>
                                            <td>{{ $company->company }}</td>
                                            @can('viewAny', App\Models\Settlement::class)
                                                <td>
                                                    <a class="btn btn-info rounded-pill"
                                                        href="{{ route('Settlement.show', $company->id) }}"> <span>
                                                            <i class="uil uil-eye"></i></span></a>
                                                </td>
                                            @endcan

                                        </tr>
                                    @endforeach
                                </tbody>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
@endsection
@section('script')
   <script>
    
   </script>
@endsection
