@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped" id="myTable">
                            <thead>
                                <tr>
                                    <th>Id</th>
                                    <th>Role</th>
                                    <th>Date de Creation</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $role->id }}</td>
                                    <td>{{ $role->role }}</td>
                                    <td>{{ $role->created_at->format('d/m/Y') }}</td>
                                </tr>
                            </tbody>
                        </table>
                        <form method="POST" action="{{ route('Permission.store2', [$role->id]) }}">
                            @csrf
                            <div class="mr-2 mt-1">
                                <h4>Ajouter une permission</h4>
                                <hr>
                                <div class="card">
                                    <div class="card-body">
                                        <h4>Assigner une permission</h4>
                                        <div class="row">
                                            @forelse ($permissions as $permission)
                                                @if ($permission->key != 100)
                                                    @if ($role->hasPermission($permission->permission))
                                                        <div class="col-md-3">

                                                            <div class="form-check form-check-inline form-switch">
                                                                <input type="checkbox" checked class="form-check-input"
                                                                    value="{{ $permission->id }}" name="permission[]"
                                                                    id="customSwitch1{{ $permission->id }}">
                                                                <label class="form-check-label"
                                                                    for="customSwitch1{{ $permission->id }}">{{ $permission->permission }}</label>
                                                            </div>
                                                        </div>
                                                    @else
                                                        <div class="col-md-3">

                                                            <div class="form-check form-check-inline form-switch">
                                                                <input type="checkbox" class="form-check-input"
                                                                    value="{{ $permission->id }}" name="permission[]"
                                                                    id="customSwitch1{{ $permission->id }}">
                                                                <label class="form-check-label"
                                                                    for="customSwitch1{{ $permission->id }}">{{ $permission->permission }}</label>
                                                            </div>
                                                        </div>
                                                    @endif
                                                @endif
                                            @empty
                                                <h3>Tableau Vide</h3>
                                            @endforelse

                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-body">
                                        <h4>Assigner Dashboard permission</h4>
                                        <div class="row">
                                            @forelse ($permissions as $permission)
                                                @if ($permission->key == 100)
                                                    @if ($role->hasPermission($permission->permission))
                                                        <div class="col-md-3">

                                                            <div class="form-check form-check-inline form-switch">
                                                                <input type="checkbox" checked class="form-check-input"
                                                                    value="{{ $permission->id }}" name="permission[]"
                                                                    id="customSwitch1{{ $permission->id }}">
                                                                <label class="form-check-label"
                                                                    for="customSwitch1{{ $permission->id }}">{{ $permission->permission }}</label>
                                                            </div>
                                                        </div>
                                                    @else
                                                        <div class="col-md-3">

                                                            <div class="form-check form-check-inline form-switch">
                                                                <input type="checkbox" class="form-check-input"
                                                                    value="{{ $permission->id }}" name="permission[]"
                                                                    id="customSwitch1{{ $permission->id }}">
                                                                <label class="form-check-label"
                                                                    for="customSwitch1{{ $permission->id }}">{{ $permission->permission }}</label>
                                                            </div>
                                                        </div>
                                                    @endif
                                                @endif
                                            @empty
                                                <h3>Tableau Vide</h3>
                                            @endforelse

                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="mt-3 ">
                                <button type="submit" class="btn btn-sm btn-primary"> Enregistrer</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
