@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="page-title-box">
                <h3 class="page-title text-success">
                    Dossiers Facturé :
                </h3>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="">
                                <thead>
                                    <tr>
                                        <th>Ref Dossier</th>
                                        <th>Ref Facture</th>
                                        <th>Company</th>
                                        <th>Type Dossier</th>
                                        <th>Montant</th>
                                        <th>Status</th>
                                        <th>Afficher</th>
                                        <th>Modifier</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($payments as $payment)
                                        <tr>
                                            <td>{{ $payment->dossier->ref ?? null }}</td>
                                            <td>{{ $payment->ref ?? null }}</td>
                                            <td>{{ $payment->notehonoraire->company->company ?? null }}</td>
                                            <td>{{ $payment->notehonoraire->typeexpertise->type ?? null }}</td>
                                            <td>{{ $payment->notehonoraire->montant ?? null }}</td>
                                            <td><span
                                                    class="badge bg-{{ $payment->status->color ?? null }}">{{ $payment->status->status ?? null }}</span>
                                            </td>
                                            <td> <a class="btn btn-sm btn-primary rounded-pill"
                                                    href="{{ route('Payment.show', $payment->id) }}">
                                                    <i class="uil uil-eye fs-5">
                                                    </i>
                                                </a>
                                            </td>
                                            <td> <a class="btn btn-sm btn-info rounded-pill"
                                                    href="{{ route('Payment.edit', $payment->id) }}">
                                                    <i class="uil uil-pen fs-5">
                                                    </i>
                                                </a>
                                            </td>
                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                            @if ($payments->hasPages())
                                <div style="float: right" class="pagination-wrapper">
                                    {{ $payments->links() }}
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Ref</th>
                                        <th>Company</th>
                                        <th>Type Dossier</th>
                                        <th>Date creation</th>
                                        <th>Afficher</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($dossiers as $dossier)
                                        <tr>
                                            <td>{{ $dossier->ref ?? null }}</td>
                                            <td>{{ $dossier->company->company ?? null }}</td>
                                            <td>{{ $dossier->typeexpertise->type ?? null }}</td>
                                            <td>{{ $dossier->created_at ?? null }}</td>

                                            <td> <a class="btn btn-sm btn-primary rounded-pill"
                                                    href="{{ route('Dossier.show', $dossier->id) }}">
                                                    <i class="uil uil-eye fs-5">
                                                    </i>
                                                </a>
                                            </td>

                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
