<!DOCTYPE html>
<html>

<head>
    <title>PDF Template</title>
    <style>
        /* Global styles for the PDF */
        body {
            font-family: Arial, sans-serif;
        }

        .header {
            text-align: center;
        }

        .footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            text-align: center;
        }

        .logo {
            max-width: 100px;
            max-height: 100px;
            margin: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid black;
            padding: 8px;
            font-size: 12px
        }
    </style>
</head>

<body>
    <div class="header">
        <h4>Canevas de récupération des pièces</h4>
    </div>
    <table>
        <thead>
            <tr>
                <th>SINISTRE</th>
            </tr>
        </thead>
    </table>
    <table>

        <tbody>
            <tr>
                <td>Garagiste : <?php echo e($dossier->garage->libelle ?? null); ?></td>
                <td>Tel : <?php echo e($dossier->insured->telephone ?? null); ?></td>
                <td>Matricule : <?php echo e($dossier->new_matricule ?? $dossier->matricule); ?></td>
            </tr>
            <tr>
                <td>Numero Sinistre : <?php echo e($dossier->numero_sinistre ?? null); ?></td>
                <td>Date Sinistre : <?php echo e($dossier->date_sinistre ?? null); ?></td>
                <td>Date Accord : <?php echo e($dossier->date_reception); ?></td>
            </tr>
            <tr>
                <td>Partie du chock : <?php $__currentLoopData = $dossier->shockpoint; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($point->point); ?>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </td>
                <td>Date prévisionnelle de sortie:</td>
                <td></td>
            </tr>
        </tbody>
    </table>

    <table style="margin-top: 10px">
        <thead>
            <tr>
                <th>Vehicule</th>
            </tr>
        </thead>
    </table>
    <table>

        <tbody>
            <tr>
                <td>Type Vehicule : <?php echo e($dossier->typevehicule->type ?? null); ?></td>
                <td>Marque : <?php echo e($dossier->vehiculemodel->brand->brand ?? null); ?></td>
                <td>Modéle : <?php echo e($dossier->vehiculemodel->name ?? null); ?></td>
            </tr>
            <tr>
                <td>MEC : <?php echo e($dossier->date_circulation ?? null); ?></td>
                <td>VIN : <?php echo e($dossier->numero_chassis ?? null); ?></td>
                <td>Kilométrage : <?php echo e($dossier->kilometrage ?? null); ?></td>
            </tr>

        </tbody>
    </table>

    <table style="margin-top: 10px">
        <thead>
            <tr>
                <th>Piéce Remplacées</th>
            </tr>
        </thead>
    </table>
    <table>

        <thead>
            <tr>
                <th>Designation</th>
                <th>Quantite</th>
                <th>
                    Gravité
                    <br>
                    <hr>
                    Moyen/Faible
                </th>
                <th>Etat
                    <br>
                    <hr>
                    Valorisable : <br>
                    OUI/NON
                </th>
                <th>Montant Accord</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $rapport->piece; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $piece): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($piece->piecetype->type ?? null); ?></td>
                    <td><?php echo e($piece->pivot->qte ?? null); ?></td>
                    <td><?php echo e($piece->gravite ?? null); ?></td>
                    <td><?php echo e($piece->etat ?? null); ?></td>
                    <td><?php echo e($piece->prix_unitaire*$piece->pivot->qte ?? null); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </tbody>
    </table>
    <h4>Observation</h4>
    <div style="border:1px solid black;width:100%,height:300px">
        <div style="padding: 15px">
            <?php $__currentLoopData = $observations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $observation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p style="font-size: 14px"><?php echo e($observation->observation ?? null); ?></p>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <table>
        <thead>
            <tr>
                <th>Visa Garage</th>
                <th>Visa Expert</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>
                    <br>
                    <br>
                    <br>
                </td>
                <td>
                    <br>
                    <br>
                    <br>
                </td>
            </tr>
        </tbody>
    </table>



</body>

</html>
<?php /**PATH C:\laragon\www\engi.ameamaroc.ma\resources\views/configuration/pdf/canevas.blade.php ENDPATH**/ ?>