
<?php

use App\Models\Operation;
use App\Models\TypeReparation;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('pieces', function (Blueprint $table) {
            $table->id();
            $table->string('piece');
            $table->foreignId('type_reparation_id')->constrained()->onDelete(null)->nullable();
            $table->foreignId('operation_id')->constrained()->onDelete(null)->nullable();
            $table->foreignId('vehicule_model_id')->constrained()->onDelete(null)->nullable();
            $table->year('model_year')->nullable();
            $table->double('prix_unitaire')->nullable();
            $table->softDeletes();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pieces');
    }
};
