<?php

namespace App\Observers;

use App\Models\Notification;
use App\Models\Rapport;
use Illuminate\Support\Facades\Auth;

class RapportObserver
{
    /**
     * Handle the Rapport "created" event.
     *
     * @param  \App\Models\Rapport  $rapport
     * @return void
     */
    public function created(Rapport $rapport)
    {
        $body = "A Creer un Nouveau Rapport :" . $rapport->dossier->ref;
        Notification::create([
            'user_id' => Auth::user()->id,
            'dossier_id' => $rapport->dossier->id,
            'body' => $body
        ]);
    }

    /**
     * Handle the Rapport "updated" event.
     *
     * @param  \App\Models\Rapport  $rapport
     * @return void
     */
    public function updated(Rapport $rapport)
    {
        //
    }

    /**
     * Handle the Rapport "deleted" event.
     *
     * @param  \App\Models\Rapport  $rapport
     * @return void
     */
    public function deleted(Rapport $rapport)
    {
        //
    }

    /**
     * Handle the Rapport "restored" event.
     *
     * @param  \App\Models\Rapport  $rapport
     * @return void
     */
    public function restored(Rapport $rapport)
    {
        //
    }

    /**
     * Handle the Rapport "force deleted" event.
     *
     * @param  \App\Models\Rapport  $rapport
     * @return void
     */
    public function forceDeleted(Rapport $rapport)
    {
        //
    }
}
