<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    use HasFactory;

    protected $fillable = [
        'ref',
        'dossier_id',
        'note_honoraire_id',
        'note_honoraire_status_id',
        'montant',
        'montant_restant',
    ];

    public function settlement()
    {
        return $this->belongsToMany(Settlement::class,'settlement_payment')->withTimestamps();
    }

    public function notehonoraire()
    {
        return $this->belongsTo(NoteHonoraire::class,'note_honoraire_id');
    }

    public function status()
    {
        return $this->belongsTo(NoteHonoraireStatus::class,'note_honoraire_status_id');
    }

    public function dossier()
    {
        return $this->belongsTo(Dossier::class);
    }
}
