<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Contradictoire extends Model
{
    use HasFactory;

    protected $fillable = [
        'dossier_id',
        'expertadverse',
        'expertarbitre',
        'adverse_id',
        'arbitre_id',
        'adverse_montant_accord',
        'arbitre_montant_accord',
        'date_reception_adverse',
        'date_reception_arbitre',
        'date_envoi_avis',
        'date_envoi_demande_arbitrage',
        'date_accord_adverse',
        'date_accord_arbitre',
        'annexe'
    ];

    public function dossier()
    {
        return $this->belongsTo(Dossier::class);
    }
    public function adverse()
    {
        return $this->belongsTo(Expert::class);
    }

    public function arbitre()
    {
        return $this->belongsTo(Expert::class);
    }

}
