<?php

namespace App\Http\Controllers;

use App\Models\TypeDocument;
use Illuminate\Http\Request;

class TypeDocumentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $typedocuments = TypeDocument::all();
        return view('configuration.Types.document.index',compact('typedocuments'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       return view('configuration.Types.document.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'type'=>'required'
        ]);
        TypeDocument::create([
            'type'=>$request->type
        ]);
        return redirect()->route('TypeDocument.index');

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\TypeDocument  $typeDocument
     * @return \Illuminate\Http\Response
     */
    public function show(TypeDocument $typeDocument)
    {

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\TypeDocument  $typeDocument
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $type = TypeDocument::whereId($id)->first();
        return view('configuration.Types.document.edit',compact('type'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\TypeDocument  $typeDocument
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,  $id)
    {
        $typeDocument = TypeDocument::whereId($id)->first();
        $typeDocument->type=$request->type;
        $typeDocument->update();

        return redirect()->route('TypeDocument.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\TypeDocument  $typeDocument
     * @return \Illuminate\Http\Response
     */

    public function destroy($id)
    {
        // $typeDocument = TypeDocument::whereId($id)->first();
        // $typeDocument->delete();
        // return redirect()->route('TypeDocument.index');

    }
}
