<?php

namespace App\Http\Controllers;

use App\Models\Company;
use App\Models\Seuil;
use App\Models\User;
use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SeuilController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('viewAny', Seuil::class);
        $users = User::where('role_id', 2)->get();

        return view('configuration.seuil.index', compact('users'));
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('create', Seuil::class);
        $seuils = Seuil::with('user')->get();
        return view('configuration.seuil.create', compact('seuils'));
    }

    public function detail($id)
    {
        $this->authorize('viewAny', Seuil::class);
        $user = User::whereId($id)->with('seuil.company')->first();
        return view('configuration.seuil.create', compact('user'));
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->authorize('create', Seuil::class);

        $request->validate([
            'accord' => 'required|numeric|min:0',
            'min' => 'required|numeric|min:0',
            'max' => 'required|numeric|min:0',
            'user' => 'required',
            'company' => 'required'

        ]);
        if($request->min >= $request->max){
            return redirect()->back()->with('error','le Montant max doit étre superieur ');
        }
        $check = Seuil::where('user_id',$request->user)->where('company_id',$request->company)->count();
        if($check>0){
            return redirect()->back()->with('error','Seuil avec cette Compagnie est déja Créer');
        }
        Seuil::create([
            'accord' => $request->accord,
            'min' => $request->min,
            'max' => $request->max,
            'user_id' => $request->user,
            'company_id' => $request->company,
        ]);

        return redirect()->route('Seuil.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Seuil  $seuil
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $this->authorize('create', Seuil::class);

        $user = User::whereId($id)->first();
        $companies = Company::all();

        return view('configuration.seuil.show', compact('user','companies'));

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Seuil  $seuil
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $this->authorize('update', Seuil::class);

        $seuil = Seuil::whereId($id)->first();
        $user = User::findOrFail($seuil->user_id);
        return view('configuration.seuil.edit', compact('seuil', 'user'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Seuil  $seuil
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->authorize('update', Seuil::class);

        $seuil = Seuil::whereId($id)->first();
        $request->validate([
            'accord' => 'required|numeric|min:0',
            'min' => 'required|numeric|min:0',
            'max' => 'required|numeric|min:0',

        ]);
        if($request->min >= $request->max){
            return redirect()->back()->with('error','le Montant max doit étre superieur ');
        }

        $seuil->accord = $request->accord;
        $seuil->min = $request->min;
        $seuil->max = $request->max;
        $seuil->update();
        return redirect()->route('Seuil.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Seuil  $seuil
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $seuil = Seuil::where('id',$id)->first();
        $seuil->delete();

        return redirect()->route('Seuil.index');
    }
}
