<?php

namespace App\Exports;

use App\Models\Dossier;
use Maatwebsite\Excel\Concerns\FromCollection;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;

class ExportDossier implements FromView
{
    /**
     * @return \Illuminate\Support\Collection
     */

    protected $request;

    function __construct($request)
    {
        $this->request = $request;
    }
    public function view(): View
    {
        
        // $imageData = $this->request->image;
        // // Create a new drawing object
        // $drawing = new Drawing();
        // $drawing->setName('Image');
        // $drawing->setDescription('Image');
        // $drawing->setPath(null);
        // $drawing->setImageResourceFromString(base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $imageData)));
        // $drawing->setCoordinates('A1');

        $dossiers = Dossier::with('insured', 'typevehicule', 'city', 'garage', 'vehiculemodel.brand', 'opponent', 'guarantee', 'company', 'garage', 'status', 'mode', 'opponent.vehiculemodel.brand','montant','onedevis','onefacture','onerapport')
        // ->whereBetween('created_at',[$this->request->from,$this->request->to])
        ->whereBetween('created_at',[$this->request->from,$this->request->to])
        ->when($this->request->company, function($query)  {
            return $query->where('company_id', $this->request->company);
        })
        ->when($this->request->intermidiaire, function($query)  {
            return $query->where('intermidiaire_id', $this->request->intermidiaire);
        })
        ->when($this->request->typeexpertise, function($query)  {
            return $query->where('type_expertise_id', $this->request->typeexpertise);
        })
        ->when($this->request->mode, function($query)  {
            return $query->where('mode_id', $this->request->mode);
        })
        ->when($this->request->garage, function($query)  {
            return $query->where('garage_id', $this->request->garage);
        })
        ->when($this->request->guarantee, function($query)  {
            return $query->where('guarantee_id', $this->request->guarantee);
        })
        ->when($this->request->vehicule_model_id, function($query)  {
            return $query->where('vehicule_model_id', $this->request->vehicule_model_id);
        })
        ->when($this->request->city_id, function($query)  {
            return $query->where('city_id', $this->request->city_id);
        })
        ->when($this->request->statut, function($query)  {
            return $query->where('dossier_status_id', $this->request->statut);
        })
        ->when($this->request->user, function($query)  {
            return $query->whereHas('step', function ($query)  {
                $query->where('user_id', $this->request->user);
            });
        })
        ->when($this->request->company_op, function($query)  {
            return $query->whereHas('opponent', function($query){
                $query->where('company_id',$this->request->company_op);
            });
        })
        ->get();
        return view('configuration.chart.excel', compact('dossiers'));
    }
}
