<?php

use App\Http\Controllers\api\ApiController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\api\AuthController;
use App\Http\Controllers\LocationController;
use App\Http\Controllers\RendezvousController;
use App\Http\Controllers\StatusRendezvousController;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    //  $request->user();
     $user = User::whereId(Auth::user()->id)->with('role')->first();
     return $user;
});

// Add these at the top of your routes file, before any other routes

Route::get('/test-middleware', function () {
    return response()->json([
        'message' => 'Middleware test',
        'middlewares' => request()->route()->middleware()
    ]);
});
Route::get('/clear-opcache', function() {
    if (function_exists('opcache_reset')) {
        opcache_reset();
        return 'OPcache cleared';
    }
    return 'OPcache not enabled';
});

Route::get('/debug-sanctum', function () {
    return response()->json([
        'sanctum_installed' => class_exists(\Laravel\Sanctum\Sanctum::class),
        'auth_guard' => config('auth.defaults.guard'),
        'api_guard_driver' => config('auth.guards.api.driver'),
        'sanctum_config_exists' => file_exists(config_path('sanctum.php')),
        'kernel_api_middlewares' => app(\Illuminate\Contracts\Http\Kernel::class)->getMiddlewareGroups()['api'] ?? 'not found',
    ]);
});

Route::middleware('auth:sanctum')->get('/test-auth', function (Request $request) {
    return response()->json([
        'authenticated' => true,
        'user' => $request->user(),
        'token' => $request->bearerToken()
    ]);
});

//check macadress for tel
Route::post('/check', [ApiController::class, 'check']);
Route::post('/login', [AuthController::class, 'login']);
Route::get('/Meeting/status/{id}',[ApiController::class, 'getstatus']);


//mobile Apis ba9i khss nchuf blan d steps mn creation l EAR
Route::middleware('auth:sanctum')->group(function () {

Route::post('/logout', [AuthController::class, 'logout']);


Route::put('meeting/cloturer/{id}', [ApiController::class, 'cloturer']);//testnow
Route::post('/meeting/upload/{id}', [ApiController::class, 'upload']); //testnow


Route::put('/user/update/token', [ApiController::class, 'updatetoken']);

//upodte km and num chassisù

Route::put('/dossier/update/{id}', [ApiController::class, 'update']);


Route::get('/role', [AuthController::class, 'role']);

// agent all  meetings with status en cours

Route::get('/meeting', [ApiController::class, 'meeting']);
Route::get('/meeting/{id}', [ApiController::class, 'showmeeting']);
Route::get('/meeting/ref/{id}', [ApiController::class, 'getref']);



// agent create observation
Route::post('/meeting/observation', [ApiController::class, 'observation']);
//show dossier
Route::get('/dossier/show/{id}', [ApiController::class, 'showdossier']);
//update meeting status
Route::put('/meeting/status/{meeting_id}', [ApiController::class, 'status']);
//all type needed
Route::get('/typedocument', [ApiController::class, 'typedocument']);

// Route::get('/typeobservation', [ApiController::class, 'typeobservation']);
// search with matricule or new matricule
Route::post('/meeting/search', [ApiController::class, 'search']);
//Agent Location every 15m
Route::post('/location', [LocationController::class, 'store']);
//Todo  add documents and image with their type
Route::get('/document/dossier/{id}', [ApiController::class, 'getDossierWithDocs']);
// get docs
Route::get('/dossier/search/{matricule}', [ApiController::class, 'getdossier']);
//demande meet
Route::post('/Demande/meeting', [ApiController::class, 'Demande']);

// Route::post('/Dossier/observation/{id}', [ApiController::class, 'observation']);


});

// web market Apis
Route::get('/dossier/{ref}', [ApiController::class, 'dossier']);
Route::get('/Garage/index', [ApiController::class, 'garages']);
//RDV
Route::get('/Rdv',[RendezvousController::class,'index']);
Route::post('/rdv',[ApiController::class,'store']);
Route::put('/Rdv/{id}',[RendezvousController::class,'update']);
Route::get('/TypeRendezVous',[ApiController::class,'typerendezvous']);
Route::get('/StatusRendezVous',[StatusRendezvousController::class,'index']);

Route::post('/manual-auth-test', function (Illuminate\Http\Request $request) {
    $bearerToken = $request->bearerToken();
    
    if (!$bearerToken || !str_contains($bearerToken, '|')) {
        return response()->json(['error' => 'Invalid token format']);
    }
    
    [$id, $token] = explode('|', $bearerToken, 2);
    
    $tokenModel = \Laravel\Sanctum\PersonalAccessToken::find($id);
    
    if (!$tokenModel) {
        return response()->json([
            'error' => 'Token not found in database',
            'token_id' => $id
        ]);
    }
    
    $hashMatches = hash_equals($tokenModel->token, hash('sha256', $token));
    
    return response()->json([
        'token_found' => true,
        'token_id' => $tokenModel->id,
        'user_id' => $tokenModel->tokenable_id,
        'token_name' => $tokenModel->name,
        'hash_matches' => $hashMatches,
        'last_used_at' => $tokenModel->last_used_at,
    ]);
});
Route::post('/debug-env', function (Illuminate\Http\Request $request) {
    return response()->json([
        'HTTP_AUTHORIZATION' => $_SERVER['HTTP_AUTHORIZATION'] ?? null,
        'REDIRECT_HTTP_AUTHORIZATION' => $_SERVER['REDIRECT_HTTP_AUTHORIZATION'] ?? null,
        'Authorization' => $request->header('Authorization'),
        'all_server' => collect($_SERVER)->filter(function($value, $key) {
            return str_contains(strtoupper($key), 'AUTH');
        })->toArray(),
    ]);
});
Route::post('/debug-bearer', function (Illuminate\Http\Request $request) {
    $bearerToken = $request->bearerToken();
    $authHeader = $request->header('Authorization');
    
    return response()->json([
        'authorization_header' => $authHeader,
        'bearer_token' => $bearerToken,
        'bearer_token_length' => $bearerToken ? strlen($bearerToken) : 0,
        'has_pipe' => $bearerToken ? str_contains($bearerToken, '|') : false,
        'x_auth_token' => $request->header('X-Auth-Token'),
    ]);
});

