@extends('layouts.dashboard.app')

@section('style')
@endsection

@section('content')
    <div class="container-fluid mt-4 ">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body mt-1">
                        <form action="{{ route('Email.store') }}" method="post">
                            @csrf
                            <div class="form-group mb-1">
                                <label for="subject">Email Sujet *:</label>
                                <textarea name="subject" required class="form-control @error('subject') is-invalid @enderror "name="subject"
                                    id="" cols="5" rows="3">
                                    {{ old('subject') }}
                                </textarea>
                                @error('subject')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group mb-1">
                                <label for="content">Email Contenu :</label>
                                <textarea name="content" required class="form-control @error('content') is-invalid @enderror "name="content"
                                    id="" cols="30" rows="10">
                                    {{ old('content') }}
                                </textarea>
                                @error('content')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="form-group mb-1">
                                <label for="delai">Delai *:</label>
                                <input type="number" name="delai" min="1"
                                    class="form-control @error('delai') is-invalid @enderror">
                                @error('delai')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="col-6">
                                <label for="type">Etapes *:</label>
                                <select name="step_id" id="step_id"
                                    class="form-control @error('step_id') is-invalid @enderror">
                                    <option value="">Selectioner Un Type</option>
                                    @foreach ($steps as $step)
                                        <option value="{{ $step->id }}">
                                            {{ $step->step }}</option>
                                    @endforeach
                                </select>
                                @error('step_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="mr-2 mt-1">
                                            <h4>Assigner Type Document</h4>
                                            {{-- <hr>
                                            <div class="form-check form-check-inline form-checkbox-warning ">
                                                <label class="form-check-label fs-4" for="selectAll">Selectioner Tout
                                                </label>
                                                <input type="checkbox" id="selectAll" class="check form-check-input">
                                            </div> --}}
                                            <hr>
                                            @forelse ($types as $type)
                                                <div class="form-check form-check-inline form-checkbox-secondary ">
                                                    <input type="checkbox" class="form-check-input check"
                                                        value="{{ $type->id }}" name="type[]"
                                                        id="customSwitch3{{ $type->id }}">
                                                    <label class="form-check-label fs-4"
                                                        for="customSwitch3{{ $type->id }}">{{ $type->type }}</label>
                                                </div>
                                            @empty
                                                <h5>Tableau Vide</h5>
                                            @endforelse
                                        </div>
                                    </div>
                                </div>
                            </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Créer</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
{{-- @section('script')
    <script>
        var checkboxes = document.getElementsByClassName('check');
        const selectAllCheckbox = document.getElementById('selectAll');

        // Add a click event listener to the "Select All" checkbox
        selectAllCheckbox.addEventListener('click', function() {
            const isChecked = selectAllCheckbox.checked;

            // Update the state of all other checkboxes
            checkboxes.forEach((checkbox) => {
                checkbox.checked = isChecked;
            });
        });

        // Add a click event listener to each individual checkbox
        checkboxes.forEach((checkbox) => {
            checkbox.addEventListener('click', function() {
                // Check if all other checkboxes are checked and update the "Select All" checkbox accordingly
                selectAllCheckbox.checked = checkboxes.length === document.querySelectorAll(
                    '.checkbox-item:checked').length;
            });
        });
    </script>
@endsection --}}
