@extends('layouts.dashboard.app')
@section('content')
    <div class="mt-3">
        <h2 class="mb-4" >Formulaires De Calcule Valeur Vénale </h2>
        <form id="myForm" method="#">
            @csrf
            <div class="row mb-4">
                <div class="col">
                    <div class="form-outline">
                        <label class="form-label" for="form3Example1">DMC :</label>
                        <input type="date" id="startdate" name="startdate" value="{{ $dossier->date_circulation ?? null }}"
                            class="form-control" />
                    </div>
                </div>
                <div class="col">
                    <div class="form-outline">
                        <label class="form-label" for="form3Example2">Date Sinistre :</label>
                        <input type="date" value="{{ $dossier->date_sinistre ?? null }}" id="enddate" name="enddate"
                            onchange="validateEndDate()" class="form-control" />
                        <span id="end-date-error" style="color:red;display:none">La date de fin doit être supérieure à la
                            date de début</span>
                    </div>
                </div>
            </div>
            <div class="row mb-4">
                <div class="col">
                    <div class="form-outline">
                        <label class="form-label" for="form3Example1">Valeur à neuf *:</label>
                        <input type="number" id="form3Example1" value="{{ $dossier->valeurneuf ?? null }}" name="valeur"
                            class="form-control" required />
                    </div>
                </div>
            </div>
            <div class="row mb-4">
                <div class="col">
                    <div class="form-outline">
                        <label class="form-label" for="form3Example1">PU *:</label>
                        <input type="number" id="form3Example1" value="{{ $dossier->puissance_fiscale }}" name="pu"
                            class="form-control" required />
                    </div>
                </div>
                <div class="col">
                    <div class="form-outline">

                        <label class="form-label" for="form3Example1">Categorie de Vehicule *:</label>
                        <select id="" class="form-control" name="pfiscale">
                            @foreach ($pfs as $pf)
                                <option value="{{ $pf->id }}">{{ $pf->text }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            <div class="row mb-4">
                <div class="col">
                    <div class="form-outline">
                        <label class="form-label" for="form3Example1">Carburant *:</label>
                        <select id="" class="form-control" name="carburant">
                            @if ($dossier->carburant_id)
                                <option value="{{ $dossier->carburant->id ?? 'Selectionner ' }}">
                                    {{ $dossier->carburant->name ?? null }}</option>
                            @endif
                            @foreach ($carburants as $carburant)
                                <option value="{{ $carburant->id }}">{{ $carburant->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col">
                    <div class="form-outline">
                        <label class="form-label" for="form3Example1">Usage *:</label>
                        <select id="" class="form-control" name="categorie">
                            @foreach ($categories as $categorie)
                                <option value="{{ $categorie->id }}">{{ $categorie->category_car }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            <div class="row mb-4">
                <div class="col">
                    <div class="form-outline">
                        <label class="form-label" for="form3Example1">Kilométrage *:</label>
                        <input type="number" id="form3Example1" name="compteur"
                            value="{{ $dossier->kilometrage ?? null }}" class="form-control" required />
                    </div>
                </div>
                <div class="col">
                    <div class="form-outline">
                        <label class="form-label" for="form3Example1">etat véhicule</label>
                        <select id="" class="form-control" name="etat">
                            @foreach ($etats as $etat)
                                <option value="{{ $etat->id }}">{{ $etat->etat }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>

            <!-- Submit button -->
            <div class="d-grid gap-2 col-6 mx-auto">
                <button type="submit" id="mybutton" class="btn btn-primary  btn-block mb-4  ml-5">Calculer</button>
            </div>

        </form>

        <div id="userData" style="display: none;" class="border border-danger container">
            <div class="border row">
                <div class="col border">
                    <h3 id="pprice"></h3>
                    <h5 id="price" class="text-success"></h5>
                </div>


                <div class="border col">
                    <h3 id="pttl"> Valeur Vénale :</h3>
                    <h5 id="ttl" class="text-success"></h5>
                </div>
            </div>


        </div>


    </div>
@endsection
@section('script')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        function validateEndDate() {
            var startDate = new Date(document.getElementById("startdate").value);
            var endDate = new Date(document.getElementById("enddate").value);

            if (endDate < startDate) {
                document.getElementById("end-date-error").style.display = "inline";
            } else {
                document.getElementById("end-date-error").style.display = "none";
            }
        }

        document.getElementById("enddate").addEventListener("change", validateEndDate);
    </script>
    <script>
        $('#myForm').submit(function(event) {
            event.preventDefault(); // prevent the form from submitting normally
            const showBtn = document.getElementById("mybutton");
            const myDiv = document.getElementById("userData");
            var formData = $(this).serialize();


            $.ajax({
                type: 'POST',
                url: '{{ route('Marketvalue.store') }}',
                data: formData,
                dataType: "json", // serializes the form's data
                success: function(data) {
                    document.getElementById('ttl').innerHTML = data[0];
                    document.getElementById('price').innerHTML = data[1];


                    if (userData.style.display === "none") {
                        userData.style.display = "block";
                    }

                },


                error: function(jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                }
            });
        });
    </script>
@endsection
