@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4 ">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('user.update', [$user->id]) }}" method="post">
                            @method('PUT')
                            @csrf

                            <div class="modal-body">

                                <div class="form-group">
                                    <label for="civilite mb-1">Civilité</label>
                                    <select class="form-select @error('civility') is-invalid @enderror" name="civility"
                                        id="civility">
                                        <option selected value="{{ $user->civility }}">{{ $user->civility }}</option>
                                        <option value="Mme">Mme</option>
                                        <option value="Mr">Mr</option>
                                        <option value="Société">Société</option>
                                    </select>
                                    @error('civility')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group mb-1">
                                    <label for="name">Nom Complet</label>
                                    <input type="text" name="name" value="{{ $user->name }}"
                                        class="form-control @error('name') is-invalid @enderror">
                                    @error('name')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group mb-1">
                                    <label for="email">Email</label>
                                    <input type="email" name="email" value="{{ $user->email }}"
                                        class="form-control @error('email') is-invalid @enderror">
                                    @error('email')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group mb-1">
                                    <label for="password">Mot de Passe :</label>
                                    <input type="password" name="password"
                                        class="form-control @error('password') is-invalid @enderror">
                                    @error('password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group mb-1">
                                    <label for="email_pro">Email Pro :</label>

                                    <input type="email_pro" name="email_pro" value="{{ $user->email_pro ?? null }}"
                                     class="form-control @error('email_pro') is-invalid @enderror">
                                    @error('email_pro')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group mb-1">
                                    <label for="password_pro">Mot de Passe Pro :</label>
                                    <input type="password_pro" name="password_pro" value=""
                                        class="form-control @error('password_pro') is-invalid @enderror">
                                    @error('password_pro')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group mb-1">
                                    <label for="ville">Ville</label>
                                    <select class="form-select @error('city') is-invalid @enderror" name="city"
                                        id="city">
                                        <option value="{{ $user->city->id }}">{{ $user->city->city }}</option>
                                        @foreach ($cities as $city)
                                            <option value="{{ $city->id }}">{{ $city->city }}</option>
                                        @endforeach
                                    </select>
                                    @error('city')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group mb-1">
                                    <label for="role">Role</label>
                                    <select class="form-select @error('role') is-invalid @enderror" name="role"
                                        id="role">
                                        <option value="{{ $user->role->id }}">{{ $user->role->role }}</option>
                                        @foreach ($roles as $role)
                                            <option value="{{ $role->id }}">{{ $role->role }}</option>
                                        @endforeach
                                    </select>
                                    @error('role')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                @if ($user->role_id != 4)
                                    <div class="form-check form-check-inline form-checkbox-warning ">
                                        <input type="checkbox" class="form-check-input"
                                            @if ($user->controler) checked @endif name="controler">
                                        <label class="form-check-label fs-4" for="customSwitch3">A Controler</label>
                                    </div>
                                @endif

                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-success">Modifier</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
