@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4 ">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body mt-1">
                        <form action="{{ route('user.store') }}" method="post">
                            @csrf
                                <div class="form-group">
                                    <label for="civilite mb-1">Civilité *:</label>
                                    <select class="form-select " name="civility"
                                        id="civility">
                                        <option value="Mr">Mr</option>
                                        <option value="Mme">Mme</option>
                                        <option value="Société">Société</option>

                                    </select>

                                </div>

                                <div class="form-group mb-1">
                                    <label for="name">Nom Complet *:</label>
                                    <input type="text" name="name" value="{{ old('name') }}" required
                                        class="form-control @error('name') is-invalid @enderror">
                                    @error('name')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group mb-1">
                                    <label for="email">Email *:</label>
                                    <input type="email" name="email" value="{{ old('email') }}" required
                                        class="form-control @error('email') is-invalid @enderror">
                                    @error('email')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group mb-1">
                                    <label for="password">Mot de Passe *:</label>
                                    <input type="password" name="password"  required
                                        class="form-control @error('password') is-invalid @enderror">
                                    @error('password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group mb-1">
                                    <label for="Role">Ville *:</label>
                                    <select class="form-select " name="city"
                                        id="city">
                                        @foreach ($cities as $city)
                                            <option value="{{ $city->id }}">{{ $city->city }}</option>
                                        @endforeach
                                    </select>

                                </div>
                             
                                <div class="form-group mb-1">
                                    <label for="role">Role *:</label>
                                    <select class="form-select " name="role"
                                        id="role">
                                        @foreach ($roles as $role)
                                            <option value="{{ $role->id }}">{{ $role->role }}</option>
                                        @endforeach
                                    </select>

                                </div>
                                
                                <div class="form-group mb-1">
                                    <div class="form-check form-check-inline form-checkbox">
                                        <input type="checkbox" class="form-check-input"
                                            name="controler">
                                        <label class="form-check-label fs-4"
                                            for="customSwitch3">A Controler</label>
                                    </div>
                                </div>

                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">Créer</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

@endsection
