@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="d-flex ">
                                <div class="col-md-6">
                                    <a style="float: left" href="{{ route('Signature.create') }}"
                                        class="btn btn-success rounded-pill"> Créer</a>
                                </div>
                            </div>
                        </div>
                        <div class="table-responsive">

                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Signature</th>
                                        <th>Role</th>
                                        <th>Modifier</th>
                                        <th>Supprimer</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($signatures as $signature)
                                        <tr>
                                            <td>{{ $signature->id }}</td>
                                            <td>
                                                <img style="width: 70px;height:100px" class="img-fluid" src="{{ Storage::disk('s3')->temporaryUrl($signature->path, now()->addMinutes(30))  }}" alt="" srcset="">
                                            </td>
                                            <td>{{ $signature->role->role }}</td>

                                            <td> <a class="btn btn-sm btn-primary rounded-pill"
                                                    href="{{ route('TypeDocument.edit', [$signature->id]) }}"><i
                                                        class="uil uil-pen fs-5"></i></a></td>
                                            <td>
                                                <form action="{{ route('TypeDocument.destroy', [$signature->id]) }}"
                                                    method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="btn btn-sm btn-danger rounded-pill" type="submit"><i
                                                            class="uil uil-trash fs-5"></i></button>
                                                </form>
                                            </td>
                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
