@extends('layouts.dashboard.app')

@section('content')
    <div class="container-fluid mt-4 ">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body mt-1">

                        <form action="{{ route('Seuil.store') }}" method="post">
                            @csrf

                            <div class="form-group mb-1">
                                <label for="role">Chiffreur :</label>
                                <select class="form-select" name="user" id="user">
                                        <option selected value="{{ $user->id }}">{{ $user->name }}</option>
                                </select>
                            </div>
                            <div class="form-group mb-1">
                                <label for="role">Compagnie :</label>
                                <select class="form-select" name="company" id="company">
                                    @foreach ($companies as $company)
                                        <option value="{{ $company->id }}">{{ $company->company }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group mb-1">
                                <label for="accord">Montant Accord :</label>
                                <input type="number" min="0" name="accord" value="{{ old('accord') }}" required
                                    class="form-control @error('accord') is-invalid @enderror">
                                @error('accord')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group mb-1">
                                <label for="min">Min Montant :</label>
                                <input type="number" min="0" name="min" value="{{ old('min') }}" required
                                    class="form-control @error('min') is-invalid @enderror">
                                @error('min')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="form-group mb-1">
                                <label for="max">Max Montant :</label>
                                <input type="number" min="0" name="max" value="{{ old('max') }}" required
                                    class="form-control @error('max') is-invalid @enderror">
                                @error('max')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Créer</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
