@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('Intermidiaire.store') }}" method="post">
                            @csrf
                            <div class=" form-group mb-3">
                                <label for="simpleinput" class="form-label">Intermidiaire *:</label>
                                <input type="text" id="company" name="company" value="{{ old('company') }}"
                                    class="form-control @error('company') is-invalid  @enderror">
                                @error('company')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class=" form-group mb-3">
                                <label for="simpleinput" class="form-label">Email *:</label>
                                <input type="email"  id="email" name="email" value="{{ old('email') }}"
                                    class="form-control @error('email') is-invalid  @enderror">
                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class=" form-group mb-3">
                                <label for="simpleinput" class="form-label">Telephone *:</label>
                                <input type="text" id="phone" name="phone" value="{{ old('phone') }}"  pattern="(\+212|0)([ \-_/]*)(\d[ \-_/]*){9}"
                                    class="form-control @error('phone') is-invalid  @enderror">
                                @error('phone')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class=" form-group mb-3">
                                <label for="simpleinput" class="form-label">Adresse :</label>
                                <input type="text" id="address" name="address" value="{{ old('address') }}"
                                    class="form-control @error('address') is-invalid  @enderror">
                                @error('address')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="mr-3 mt-3">
                                <button class="btn btn-primary" type="submit">Créer</button>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
