@extends('layouts.config_dashboard.app')

@section('content')
<div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="d-flex ">
                                <div class="col-md-6">
                                    <a style="float: left" href="{{ route('PieceType.create') }}"
                                        class="btn btn-success rounded-pill"> Créer</a>
                                </div>
                                <div class="col-md-6">
                                    <a style="float: right" href="{{ route('PieceType.deleted') }}"
                                        class="btn btn-warning rounded-pill"> Restaurer</a>
                                </div>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Type Piece</th>
                                        <th>Modifier</th>
                                        <th>Supprimer</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($typepieces as $piece)
                                        <tr>
                                            <td>{{ $piece->id }}</td>
                                            <td>{{ $piece->type }}</td>
                                            <td> <a class="btn btn-sm btn-primary rounded-pill"
                                                    href="{{ route('PieceType.edit', $piece->id) }}"><i
                                                        class="uil uil-pen fs-5"></i></a></td>
                                            <td>
                                                <form action="{{ route('PieceType.destroy', [$piece->id]) }}" method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="btn btn-sm btn-danger rounded-pill" type="submit">
                                                        <i class="uil uil-trash fs-5"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
