<?php $__env->startSection('content'); ?>


    <div class="container">
        <h1>Screen Recorder</h1>
        <video id="screenVideo"></video>
        <button id="startButton">Start Recording</button>
        <button id="stopButton" disabled>Stop Recording</button>
        <button id="downloadButton" disabled>Download Video</button>
        <input id="file" type="hidden" name="video">
        <div class="recorded-video-wrap">
            <video style="display: none" id="video" controls></video>
            <video style="display: none" src="" id="recorded-video" controls></video>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <iframe width="2000" height="1200" src="https://engi.whereby.com/f5470cbd-fb1c-4600-9c31-41ee2d158146"
                allow="camera; microphone; fullscreen; speaker; display-capture; autoplay; compute-pressure"></iframe>
        </div>

    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        const screenVideoElement = document.getElementById('screenVideo');
        const startButton = document.getElementById('startButton');
        const stopButton = document.getElementById('stopButton');
        const downloadButton = document.getElementById('downloadButton');
        let mediaRecorder;
        let recordedChunks = [];
        recordedVideo = document.querySelector('#recorded-video');
        const stream = await navigator.mediaDevices.getDisplayMedia({
                    video: true,
                    audio: true
                });
        async  function startRecording() {
            try {
               
                console.log(stream.getAudioTracks());

                screenVideoElement.srcObject = stream;
                mediaRecorder = new MediaRecorder(stream);

                mediaRecorder.ondataavailable = (event) => {
                    if (event.data.size > 0) {
                        recordedChunks.push(event.data);
                    }
                };

                mediaRecorder.onstop = () => {
                    downloadButton.disabled = false;
                };

                mediaRecorder.start();
                startButton.disabled = true;
                stopButton.disabled = false;
            } catch (error) {
                console.error('Error starting recording: ', error);
            }
        }

        function stopRecording() {
            if (mediaRecorder && mediaRecorder.state === 'recording') {
                mediaRecorder.stop();
                startButton.disabled = false;
                stopButton.disabled = true;

            }
        }

        function downloadVideo(stream) {
            const blob = new Blob(recordedChunks, {
                'type': 'video/mp4'
            });
            recordedVideo.src = URL.createObjectURL(blob);
            recordedVideo.load();
            const formData = new FormData();
            var dossier_id = 166;

            formData.append('video', blob);
            fetch('http://127.0.0.1:8000/Call/store/' + dossier_id, {

                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    body: formData
                })
                .then(response => {
                    console.log(response);
                })
                .catch(error => {
                    console.log(error);
                });

            recordedVideo.onloadeddata = function() {
                const rc = document.querySelector(".recorded-video-wrap");
                rc.classList.remove("hidden");
                rc.scrollIntoView({
                    behavior: "smooth",
                    block: "start"
                });
                recordedVideo.play();
            }

            stream.getTracks().forEach((track) => track.stop());
            audio.getTracks().forEach((track) => track.stop());

            console.log('Recording stopped');
        }




        startButton.addEventListener('click', startRecording);
        stopButton.addEventListener('click', stopRecording);
        downloadButton.addEventListener('click', () => downloadVideo(stream));
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\engi.ameamaroc.ma\resources\views/call/create.blade.php ENDPATH**/ ?>