<?php $__env->startSection('style'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/viewer.css')); ?>">

    <style>
        * {
            box-sizing: border-box;
        }

        #the-canvas {
            border: 1px solid black;
            direction: ltr;
        }

        * {
            box-sizing: border-box;
        }

        li {
            text-decoration: none;
        }

        /* Position the image container (needed to position the left and right arrows) */
        .container {
            position: relative;
        }

        /* Hide the images by default */
        .mySlides {
            display: none;
        }

        /* Add a pointer when hovering over the thumbnail images */
        .cursor {
            cursor: pointer;
        }

        /* Next & previous buttons */
        .prev,
        .next {
            cursor: pointer;
            position: absolute;
            top: 40%;
            width: auto;
            padding: 16px;
            margin-top: -50px;
            color: white;
            font-weight: bold;
            font-size: 20px;
            border-radius: 0 3px 3px 0;
            user-select: none;
            -webkit-user-select: none;
        }

        /* Position the "next button" to the right */
        .next {
            right: 0;
            border-radius: 3px 0 0 3px;
        }

        /* On hover, add a black background color with a little bit see-through */
        .prev:hover,
        .next:hover {
            background-color: rgba(0, 0, 0, 0.8);
        }

        /* Number text (1/3 etc) */
        .numbertext {
            color: #f2f2f2;
            font-size: 12px;
            padding: 8px 12px;
            position: absolute;
            top: 0;
        }

        /* Container for image text */
        .caption-container {
            text-align: center;
            background-color: #222;
            padding: 2px 16px;
            color: white;
        }

        .row:after {
            content: "";
            display: table;
            clear: both;
        }

        /* Six columns side by side */
        .column {
            float: left;
            width: 16.66%;
        }

        /* Add a transparency effect for thumnbail images */
        .demo {
            opacity: 0.6;
        }

        .active,
        .demo:hover {
            opacity: 1;
        }

        .container {
            position: relative;
            width: 33%;
        }

        .image {
            opacity: 1;
            display: block;
            width: 100%;
            height: auto;
            transition: .5s ease;
            backface-visibility: hidden;
        }

        .middle {
            transition: .5s ease;
            opacity: 0;
            position: absolute;
            top: 28%;
            left: 82%;
            transform: translate(-50%, -50%);
            -ms-transform: translate(-50%, -50%);
            text-align: center;
        }

        .container:hover .image {
            opacity: 0.8;
        }

        .container:hover .middle {
            opacity: 1;
        }

        .text {
            color: rgb(0, 0, 0);
            font-size: 16px;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title mb-3">Dossier <?php echo e($dossier->ref); ?></h4>
                    <input type="hidden" value="<?php echo e($dossier->id); ?>" id="id">

                    <div class="table-responsive">
                        <table class="table mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>Reference</th>
                                    <th>Matricule</th>
                                    <th>Compagnie</th>
                                    <th>Garantie</th>
                                    <th>Date Sinistre</th>
                                    <th>Type de Dossier</th>
                                    <th>Mode</th>
                                    <th>Vehicule</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><?php echo e($dossier->ref ?? null); ?></td>
                                    <td><?php echo e($dossier->matricule ?? null); ?></td>
                                    <td><?php echo e($dossier->company->company ?? null); ?></td>
                                    <td><?php echo e($dossier->guarantee->guarantee ?? null); ?></td>
                                    <td><?php echo e($dossier->date_sinistre ?? null); ?></td>
                                    <td> <span
                                            class="badge badge-info-lighten"><?php echo e($dossier->typeexpertise->type ?? null); ?></span>
                                    </td>
                                    <td> <span class="badge badge-success-lighten"><?php echo e($dossier->mode->mode ?? null); ?></span>
                                    </td>
                                    <td><?php echo e($dossier->vehiculemodel->name ?? null); ?>/<?php echo e($dossier->vehiculemodel->brand->brand ?? null); ?>

                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <!-- end table-responsive -->
                </div>
            </div>
        </div> <!-- end col -->


    </div>

    <div class="row">
        <div class="col-6 mt-4">
            <input type="hidden" value="<?php echo e(Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30))); ?>"
                id="url">

            <?php if($rapport->rapport_status_id == 4): ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('signer', App\Models\Rapport::class)): ?>
                    <form action="<?php echo e(route('rapport.status')); ?>" class="mb-1" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" value="<?php echo e($rapport->id); ?>" name="rapport_id">
                        <ul class="nav nav-tabs nav-stacked ">


                            <div class="col-4">
                                <button type="submit" class="ml-5 btn btn-danger" style="" name="action" value="0">
                                    Refuser </button>
                            </div>
                            <div class="col-4">
                                <button style="float: right" type="submit" class=" btn btn-success" name="action"
                                    value="1"> Signer </button>
                            </div>
                        </ul>
                    </form>
                <?php endif; ?>
            <?php elseif($rapport->rapport_status_id == 2): ?>
                <?php if(Auth::user()->role_id == 4 || Auth::user()->role_id == 1): ?>
                    <form action="<?php echo e(route('rapport.status')); ?>" class="mb-1" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" value="<?php echo e($rapport->id); ?>" name="rapport_id">

                        <button type="submit" class="ml-5 btn btn-info mb-2" style="" name="action" value="2">
                            Envoyer
                        </button>

                    </form>
                <?php endif; ?>
            <?php else: ?>
                <div class="col-4">
                    <a class="btn btn-primary" target="_blank"
                        href="<?php echo e(Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30))); ?>">Display</a>
                </div>
                <h3>Rapport : <span class=" badge bg-<?php echo e($rapport->status->color); ?>"><?php echo e($rapport->status->status); ?></span>
                </h3>
            <?php endif; ?>

            <div class="mt-1 mb-1 div">
                <button class="btn btn-sm btn-outline-info" id="prev">Previous</button>
                &nbsp; &nbsp;
                <span>Page: <span id="page_num"></span> / <span id="page_count"></span></span>
                &nbsp; &nbsp;

                <button class="btn btn-sm btn-outline-info" id="next">Next</button>
            </div>
            <canvas id="the-canvas"></canvas>

        </div>
        <div class="col-6 mt-4">
            <div class="">
                <ul class="nav nav-tabs nav-stacked ">
                    <?php $__currentLoopData = $typedocuments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="nav-item ">
                            <button type="button" data-filter="<?php echo e($type->type); ?>" class="link nav-link"
                                style=" cursor: pointer;" value="<?php echo e($type->id); ?>"><?php echo e($type->type); ?> </button>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </ul>
                <div class="card-body m-1" id="galley" style="height: 300px; overflow-y:auto">
                    <input type="hidden" id="id" name="dossier_id" value="<?php echo e($dossier->id); ?>">
                    <?php if($dossier->document): ?>
                        <ul style=" list-style-type: none;" id="row" class="row">
                            <?php $__currentLoopData = $dossier->document; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($doc->type_document_id != 10): ?>
                                    <li class="box container col-3 media <?php echo e($doc->typedocument->type); ?> ">
                                        <img data-original="<?php echo e(Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30))); ?>"
                                            src="<?php echo e(Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30))); ?>"
                                            alt="img" class="img-fluid m-1" srcset="">
                                        <div class="middle">
                                            <a data-bs-toggle="modal" data-bs-target="#exampleModal" href=""
                                                class="text icon dripicons-document-edit"></a>
                                        </div>
                                        <span class="badge bg-primary m-1"
                                            style="display: block;"><?php echo e($doc->typedocument->type ?? null); ?></span>
                                    </li>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        </ul>
                    <?php endif; ?>
                </div>


            </div>
        </div>
    </div>
    <div class="row mt-2">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-body">

                    <h4 class="header-title mb-3" style="color: black">Observation</h4>
                    <?php if($observations): ?>
                        <div class="accordion" id="">
                            <?php $__currentLoopData = $observations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $observation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="headingOne" style="margin-top: unset;">
                                        <button class="accordion-button collapsed" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#collapse-<?php echo e($key); ?>"
                                            aria-expanded="false" aria-controls="">
                                            <?php echo e($observation->user->name); ?>

                                        </button>
                                    </h2>
                                    <div id="collapse-<?php echo e($key); ?>" class="accordion-collapse collapse "
                                        aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <strong class="text-dark"><?php echo e($observation->observation); ?>.</strong>
                                            <span><?php echo e($observation->created_at); ?></span>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endif; ?>
                    <form method="POST" action="<?php echo e(route('Observation.store')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="col-md-12 mt-1 ml-3">
                            <input type="hidden" name="for_rapport" value="1">
                            <input type="hidden" name="dossier_id" value="<?php echo e($dossier->id); ?>">
                            <input type="hidden" name="rapport_id" value="<?php echo e($rapport->id); ?>">
                            <textarea name="observation" class="form-control mb-2" id="observation" cols="30" rows="10"></textarea>

                            <button class="mt-2 btn btn-info">Créer</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script src="https://mozilla.github.io/pdf.js/build/pdf.js"></script>
    <script type="text/javascript" src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>
    <script src="<?php echo e(asset('js/viewer.js')); ?>"></script>
    <script>
        var $mediaElements = $('.media');

        $('.link').click(function(e) {
            e.preventDefault();
            // get the category from the attribute
            var filterVal = $(this).data('filter');
            console.log(filterVal);
            var type_id = this.value;
            if (filterVal === 'AA') {
                $mediaElements.show();
            } else {
                // hide all then filter the ones to show
                $mediaElements.hide().filter('.' + filterVal).show();
            }
        });
        // $(document).ready(function() {
        //     $('.link').on('click', function() {

        //         var type_id = this.value;
        //         var dossier_id = jQuery('#id').val();
        //         $(".box").remove();
        //         var divs = document.getElementsByClassName('type_id')
        //         // $.ajax({
        //         //     url: '/Document/' + dossier_id + '/Type/' + type_id,
        //         //     type: 'get',
        //         //     context: this,

        //         //     success: function(response) {

        //         //         $.each(response, function(key, value) {
        //         //             console.log(value);
        //         //             $("#row").append(
        //         //                 '<li class=\"box col-3 container\"> <img  data-original="' +
        //         //                 value + '"  src="' +
        //         //                 value +
        //         //                 '"  class=\"img-fluid m-1\" > <div class=\"middle\">      <a href="" class=\"text icon dripicons-document-edit\"></a> </div> <span class=\"badge bg-primary m-1\" style=\"display: block;\">Avant</span></li>'
        //         //             );
        //         //         });
        //         //     },
        //         // });
        //     });
        // });
    </script>
    <script>
        $('#toolbox-clear-canvas').on('click', function() {
            var ok = confirm('Effacer la zone de dessin ?');
            if (ok) {
                editor.clearCanvas();
            }
            return false;
        });

        $('#toolbox-remove-element').on('click', function() {
            //--
            var ok = confirm("Supprimer l'élément sélectionné de la zone de dessin?");
            if (ok) {
                editor.removeSelected();
            }
            //--
            return false;
            //--
        });
        $('#toolbox-color').on('change', function() {
            //--
            var val = $(this).val();
            //	console.log(val);
            if (!val) {
                return;
            } //end if
            editor.setColorOnSelected('fill', val);
            //--
            return false;
            //--
        });

        $('#toolbox-scolor').on('change', function() {
            //--
            var val = $(this).val();
            //	console.log(val);
            if (!val) {
                return;
            } //end if
            editor.setColorOnSelected('stroke', val);
            //--
            return false;
            //--
        });
        // to json
        var btnEl = document.createElement("button");
        btnEl.innerHTML = "Enregistrer";
        btnEl.classList.add('btn');
        btnEl.classList.add('btn-primary');
        btnEl.id = "to-json";
        document.getElementById("btn").appendChild(btnEl);
        const screenshotTarget = document.getElementById('c');

        btnEl.onclick = function() {
            html2canvas(screenshotTarget).then(canvas => {

                console.log(canvas.toDataURL("image/png"));

            });

            var img = smartJ$Browser.VirtualFileDownload(
                String(JSON.stringify(canvas, null, 2)),
                "drawing.fabric.json",
                "application/json",
                "UTF-8"
            );
            console.log(img);
        };
    </script>
    <script>
        (function() {
            var theTextureImage = '<?php echo e(asset('css/SVG/server.svg')); ?>';
            var isCanvasDrawingMode = null;
            var drawingModeEl = $('#drawing-mode'),
                drawingOptionsEl = $('#drawing-mode-options'),
                drawingColorEl = $('#drawing-color'),
                drawingShadowColorEl = $('#drawing-shadow-color'),
                drawingLineWidthEl = $('#drawing-line-width'),
                drawingShadowWidth = $('#drawing-shadow-width'),
                drawingShadowOffset = $('#drawing-shadow-offset');
            drawingModeEl.on('click', function() {
                if (isCanvasDrawingMode === null) {
                    isCanvasDrawingMode = false;
                } else {
                    isCanvasDrawingMode = !isCanvasDrawingMode;
                }
                if (isCanvasDrawingMode) {
                    $('#toolbox').hide();
                    drawingModeEl.text('Annuler le mode dessin');
                    drawingOptionsEl.show();
                } else {
                    $('#toolbox').show();
                    drawingModeEl.text('Entrer en mode dessin');
                    drawingOptionsEl.hide();
                }
                editor.canvasToggleDrawingMode(!!isCanvasDrawingMode);
            }).trigger('click');

            if (fabric.PatternBrush) {

                var vLinePatternBrush = new fabric.PatternBrush(canvas);

                vLinePatternBrush.getPatternSrc = function() {

                    var patternCanvas = fabric.document.createElement('canvas');
                    patternCanvas.width = patternCanvas.height = 10;
                    var ctx = patternCanvas.getContext('2d');

                    ctx.strokeStyle = this.color;
                    ctx.lineWidth = 5;
                    ctx.beginPath();
                    ctx.moveTo(0, 5);
                    ctx.lineTo(10, 5);
                    ctx.closePath();
                    ctx.stroke();

                    return patternCanvas;
                };

                var hLinePatternBrush = new fabric.PatternBrush(canvas);
                hLinePatternBrush.getPatternSrc = function() {

                    var patternCanvas = fabric.document.createElement('canvas');
                    patternCanvas.width = patternCanvas.height = 10;
                    var ctx = patternCanvas.getContext('2d');

                    ctx.strokeStyle = this.color;
                    ctx.lineWidth = 5;
                    ctx.beginPath();
                    ctx.moveTo(5, 0);
                    ctx.lineTo(5, 10);
                    ctx.closePath();
                    ctx.stroke();

                    return patternCanvas;
                };

                var squarePatternBrush = new fabric.PatternBrush(canvas);
                squarePatternBrush.getPatternSrc = function() {

                    var squareWidth = 10,
                        squareDistance = 2;

                    var patternCanvas = fabric.document.createElement('canvas');
                    patternCanvas.width = patternCanvas.height = squareWidth + squareDistance;
                    var ctx = patternCanvas.getContext('2d');

                    ctx.fillStyle = this.color;
                    ctx.fillRect(0, 0, squareWidth, squareWidth);

                    return patternCanvas;
                };

                var diamondPatternBrush = new fabric.PatternBrush(canvas);
                diamondPatternBrush.getPatternSrc = function() {

                    var squareWidth = 10,
                        squareDistance = 5;
                    var patternCanvas = fabric.document.createElement('canvas');
                    var rect = new fabric.Rect({
                        width: squareWidth,
                        height: squareWidth,
                        angle: 45,
                        fill: this.color
                    });

                    var canvasWidth = rect.getBoundingRect().width;

                    patternCanvas.width = patternCanvas.height = canvasWidth + squareDistance;
                    rect.set({
                        left: canvasWidth / 2,
                        top: canvasWidth / 2
                    });

                    var ctx = patternCanvas.getContext('2d');
                    rect.render(ctx);

                    return patternCanvas;
                };

                var img = new Image();
                var texturePatternBrush = null;
                img.onload = function() {
                    texturePatternBrush = new fabric.PatternBrush(canvas);
                    texturePatternBrush.source = this;
                };
                img.src = String(theTextureImage);

            }

            $('#drawing-mode-selector').on('change', function() {
                //--
                theVal = $(this).val() || '';
                //--
                switch (theVal.toLowerCase()) {
                    case 'hline':
                        canvas.freeDrawingBrush = hLinePatternBrush;
                        break;
                    case 'vline':
                        canvas.freeDrawingBrush = vLinePatternBrush;
                        break;
                    case 'square':
                        canvas.freeDrawingBrush = squarePatternBrush;
                        break;
                    case 'diamond':
                        canvas.freeDrawingBrush = diamondPatternBrush;
                        break;
                    case 'texture':
                        if (texturePatternBrush) {
                            canvas.freeDrawingBrush = texturePatternBrush;
                        } else {
                            console.error('Cannot Load Pattern Image: ' + theTextureImage);
                        }
                        break;
                    default:
                        try {
                            canvas.freeDrawingBrush = new fabric[theVal.charAt(0).toUpperCase() + theVal.slice(
                                1) + 'Brush'](canvas);
                        } catch (err) {
                            console.error('Error: ' + err);
                            return;
                        }
                } //end switch
                //--
                if (canvas.freeDrawingBrush) {
                    canvas.freeDrawingBrush.color = drawingColorEl.val();
                    canvas.freeDrawingBrush.width = parseInt(drawingLineWidthEl.val(), 10) || 1;
                    canvas.freeDrawingBrush.shadow = new fabric.Shadow({
                        blur: parseInt(drawingShadowWidth.val(), 10) || 0,
                        offsetX: 0,
                        offsetY: 0,
                        affectStroke: true,
                        color: drawingShadowColorEl.val(),
                    });
                }
                //--
            });

            drawingColorEl.on('change', function() {
                canvas.freeDrawingBrush.color = $(this).val();
            });
            drawingShadowColorEl.on('change', function() {
                canvas.freeDrawingBrush.shadow.color = $(this).val();
            });
            drawingLineWidthEl.on('change', function() {
                canvas.freeDrawingBrush.width = parseInt($(this).val(), 10) || 1;
                $(this).prev().text($(this).val());
            });
            drawingShadowWidth.on('change', function() {
                canvas.freeDrawingBrush.shadow.blur = parseInt($(this).val(), 10) || 0;
                $(this).prev().text($(this).val());
            });
            drawingShadowOffset.on('change', function() {
                canvas.freeDrawingBrush.shadow.offsetX =
                    canvas.freeDrawingBrush.shadow.offsetY = parseInt($(this).val(), 10) || 0;
                $(this).prev().text($(this).val());
            });

            if (canvas.freeDrawingBrush) {
                canvas.freeDrawingBrush.color = drawingColorEl.val();
                canvas.freeDrawingBrush.width = parseInt(drawingLineWidthEl.val(), 10) || 1;
                canvas.freeDrawingBrush.shadow = new fabric.Shadow({
                    blur: parseInt(drawingShadowWidth.val(), 10) || 0,
                    offsetX: 0,
                    offsetY: 0,
                    affectStroke: true,
                    color: drawingShadowColorEl.val(),
                });
            }
        })();
    </script>
    <script>
        window.addEventListener('load', function() {
            console.log('DOM fully loaded and parsed');
            var galley = document.getElementById('galley');
            var maxOffsetPercentage = 0.9;
            var viewer = new Viewer(galley, {
                url: 'data-original',
                backdrop: 'static',
                move: function(event) {
                    var viewerData = viewer.viewerData;
                    var imageData = viewer.imageData;
                    var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                    var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                    var detail = event.detail;
                    var left = detail.x;
                    var top = detail.y;
                    var right = viewerData.width - (left + imageData.width);
                    var bottom = viewerData.height - (top + imageData.height);
                    if (
                        // Move left
                        (detail.x < detail.oldX && right > 0 && right > maxOffsetHorizontal)
                        // Move right
                        ||
                        (detail.x > detail.oldX && left > 0 && left > maxOffsetHorizontal)
                        // Move up
                        ||
                        (detail.y < detail.oldY && bottom > 0 && bottom > maxOffsetVertical)
                        // Move down
                        ||
                        (detail.y > detail.oldY && top > 0 && top > maxOffsetVertical)
                    ) {
                        event.preventDefault();
                    }
                },
                zoomed: function(event) {
                    var detail = event.detail;
                    // Zoom out
                    if (detail.ratio < detail.oldRatio) {
                        var viewerData = viewer.viewerData;
                        var imageData = viewer.imageData;
                        var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                        var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                        var left = imageData.x;
                        var top = imageData.y;
                        var right = viewerData.width - (left + imageData.width);
                        var bottom = viewerData.height - (top + imageData.height);
                        var x = 0;
                        var y = 0;
                        if (right > 0 && right > maxOffsetHorizontal) {
                            x = maxOffsetHorizontal - right;
                        }
                        if (left > 0 && left > maxOffsetHorizontal) {
                            x = maxOffsetHorizontal - left;
                        }

                        if (bottom > 0 && bottom > maxOffsetVertical) {
                            y = bottom - maxOffsetVertical;
                        }

                        if (top > 0 && top > maxOffsetVertical) {
                            y = top - maxOffsetVertical;
                        }

                        // Move the image into view if it is invisible
                        if (x !== 0 || y !== 0) {
                            viewer.move(x, y);
                        }
                    }
                },
            });
        });
        var links = document.getElementsByClassName('link');
        for (var i = 0; i < links.length; i++) {

            links[i].addEventListener('click', function() {
                console.log('clcl');
                var galley = document.getElementById('galley');
                var maxOffsetPercentage = 0.9;
                var viewer = new Viewer(galley, {
                    url: 'data-original',
                    backdrop: 'static',
                    move: function(event) {
                        var viewerData = viewer.viewerData;
                        var imageData = viewer.imageData;
                        var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                        var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                        var detail = event.detail;
                        var left = detail.x;
                        var top = detail.y;
                        var right = viewerData.width - (left + imageData.width);
                        var bottom = viewerData.height - (top + imageData.height);
                        if (
                            // Move left
                            (detail.x < detail.oldX && right > 0 && right > maxOffsetHorizontal)
                            // Move right
                            ||
                            (detail.x > detail.oldX && left > 0 && left > maxOffsetHorizontal)
                            // Move up
                            ||
                            (detail.y < detail.oldY && bottom > 0 && bottom > maxOffsetVertical)
                            // Move down
                            ||
                            (detail.y > detail.oldY && top > 0 && top > maxOffsetVertical)
                        ) {
                            event.preventDefault();
                        }
                    },
                    zoomed: function(event) {
                        var detail = event.detail;
                        // Zoom out
                        if (detail.ratio < detail.oldRatio) {
                            var viewerData = viewer.viewerData;
                            var imageData = viewer.imageData;
                            var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                            var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                            var left = imageData.x;
                            var top = imageData.y;
                            var right = viewerData.width - (left + imageData.width);
                            var bottom = viewerData.height - (top + imageData.height);
                            var x = 0;
                            var y = 0;
                            if (right > 0 && right > maxOffsetHorizontal) {
                                x = maxOffsetHorizontal - right;
                            }
                            if (left > 0 && left > maxOffsetHorizontal) {
                                x = maxOffsetHorizontal - left;
                            }

                            if (bottom > 0 && bottom > maxOffsetVertical) {
                                y = bottom - maxOffsetVertical;
                            }

                            if (top > 0 && top > maxOffsetVertical) {
                                y = top - maxOffsetVertical;
                            }

                            // Move the image into view if it is invisible
                            if (x !== 0 || y !== 0) {
                                viewer.move(x, y);
                            }
                        }
                    },
                });
            });
        }
    </script>
    <script>
        // If absolute URL from the remote server is provided, configure the CORS
        // header on that server.

        var url = document.getElementById('url').value;
        // Loaded via <script> tag, create shortcut to access PDF.js exports.
        var pdfjsLib = window['pdfjs-dist/build/pdf'];
        console.log(url);
        // The workerSrc property shall be specified.
        pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://mozilla.github.io/pdf.js/build/pdf.worker.js';

        var pdfDoc = null,
            pageNum = 1,
            pageRendering = false,
            pageNumPending = null,
            scale = 0.8,
            canvas = document.getElementById('the-canvas'),
            ctx = canvas.getContext('2d');

        /**
         * Get page info from document, resize canvas accordingly, and render page.
         * @param num Page number.
         */
        function renderPage(num) {
            pageRendering = true;
            // Using promise to fetch the page
            pdfDoc.getPage(num).then(function(page) {
                var viewport = page.getViewport({
                    scale: scale
                });
                canvas.height = viewport.height;
                canvas.width = viewport.width;

                // Render PDF page into canvas context
                var renderContext = {
                    canvasContext: ctx,
                    viewport: viewport
                };
                var renderTask = page.render(renderContext);

                // Wait for rendering to finish
                renderTask.promise.then(function() {
                    pageRendering = false;
                    if (pageNumPending !== null) {
                        // New page rendering is pending
                        renderPage(pageNumPending);
                        pageNumPending = null;
                    }
                });
            });

            // Update page counters
            document.getElementById('page_num').textContent = num;
        }

        /**
         * If another page rendering in progress, waits until the rendering is
         * finised. Otherwise, executes rendering immediately.
         */
        function queueRenderPage(num) {
            if (pageRendering) {
                pageNumPending = num;
            } else {
                renderPage(num);
            }
        }

        /**
         * Displays previous page.
         */
        function onPrevPage() {
            if (pageNum <= 1) {
                return;
            }
            pageNum--;
            queueRenderPage(pageNum);
        }
        document.getElementById('prev').addEventListener('click', onPrevPage);

        /**
         * Displays next page.
         */
        function onNextPage() {
            if (pageNum >= pdfDoc.numPages) {
                return;
            }
            pageNum++;
            queueRenderPage(pageNum);
        }
        document.getElementById('next').addEventListener('click', onNextPage);

        /**
         * Asynchronously downloads PDF.
         */
        pdfjsLib.getDocument(url).promise.then(function(pdfDoc_) {
            pdfDoc = pdfDoc_;
            document.getElementById('page_count').textContent = pdfDoc.numPages;

            // Initial/first page rendering
            renderPage(pageNum);
        });

        var $mediaElements = $('.media');
        var canvas = document.getElementById("the-canvas");

        var ctx = canvas.getContext('2d');

        ctx.fillStyle = "rgb(0,255,255)";
        ctx.fillRect(0, 0, canvas.width, canvas.height);

        ctx.beginPath();
        ctx.fillStyle = "rgb(200,0,0)";
        ctx.arc(canvas.width / 2, canvas.height / 2, 50, 0, Math.PI * 2);
        ctx.fill();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\AMEA\resources\views/rapport/signature.blade.php ENDPATH**/ ?>