<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Brand;
use Illuminate\Support\Facades\Auth;
use Illuminate\Auth\Access\HandlesAuthorization;

class BrandPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        $user = User::findOrFail(Auth::user()->id);
        if( $user->role_id === 4 || $user->hasPermission('naviguer_marques') || $user->hasRolePermission('naviguer_marques') ){
            return true;
        }
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Brand  $brand
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user)
    {
        $user = User::whereId(Auth::user()->id)->first();
        if( $user->role_id === 4  ||  $user->hasPermission('afficher_marques') || $user->hasRolePermission('afficher_marques')){
            return true;
        }
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        $user = User::findOrFail(Auth::user()->id);
        if($user->hasPermission('ajouter_marques') || $user->hasRolePermission('ajouter_marques') || $user->role_id === 4 ){
            return true;
        }
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Brand  $brand
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user)
    {
        $user = User::findOrFail(Auth::user()->id);
        if( $user->role_id === 4 || $user->hasPermission('modifier_marques') || $user->hasRolePermission('modifier_marques')  ){
            return true;
        }
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Brand  $brand
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user)
    {
        $user = User::findOrFail(Auth::user()->id);
        if( $user->role_id === 4 || $user->hasPermission('supprimer_marques') || $user->hasRolePermission('supprimer_marques')  ){
            return true;
        }
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Brand  $brand
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Brand  $brand
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user, Brand $brand)
    {
        //
    }
}
