<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Rapport extends Model
{
    use HasFactory;

    protected $fillable = ['dossier_id','rapport_status_id','taux_id','document_id'];

    public function dossier()
    {
        return $this->belongsTo(Dossier::class);
    }

    public function status()
    {
        return $this->belongsTo(RapportStatus::class,'rapport_status_id');
    }
    public function rapportstatus()
    {
        return $this->belongsToMany(RapportStatus::class,'rapport_status')->withPivot('user_id')->withTimestamps();
    }

    public function piecetype()
    {
        return $this->belongsToMany(PieceType::class,'rapport_piecetype');
    }

    public function piece()
    {
        return $this->belongsToMany(Piece::class,'rapport_piece')->withPivot(['qte','prix_unitaire','etat','gravite','vetuste','remise','montant_ht','type_reparation_id','operation_id','vehicule_model_id'])
        ->using(RapportPiece::class)->withTrashed()->withTimestamps();
    }

    public function documents()
    {
        return $this->belongsToMany(Document::class,'rapport_document')->withPivot('observation')->withTimestamps();
    }

    public function taux()
    {
        return $this->belongsTo(Taux::class);
    }

    public function document()
    {
        return $this->belongsTo(Document::class );
    }

}
