<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Piece extends Model
{
    use HasFactory,SoftDeletes;

    protected $fillable = ['piece','vehicule_model_id','type_reparation_id','operation_id','prix_unitaire','piece_type_id','etat','gravite'];

    public function vehiculemodel()
    {
        return $this->belongsTo(VehiculeModel::class,'vehicule_model_id')->withTrashed();
    }

    public function devis()
    {
        return $this->belongsToMany(Devis::class,'devis_piece')
        ->withPivot(['qte','prix_unitaire','etat','gravite','vetuste','remise','montant_ht','type_reparation_id','operation_id','vehicule_model_id'])
        ->withTimestamps();
    }

    public function rapport()
    {
        return $this->belongsToMany(Rapport::class,'rapport_piece')->withPivot(['qte','prix_unitaire','etat','gravite','vetuste','remise','montant_ht','type_reparation_id','operation_id','vehicule_model_id'])
        ->withTimestamps();
    }

    public function typereparation()
    {
        return $this->belongsTo(TypeReparation::class,'type_reparation_id');
    }

    public function mode()
    {
        return $this->belongsTo(PieceMode::class);
    }

    public function operation()
    {
        return $this->belongsTo(Operation::class);
    }

    public function piecetype(){

        return $this->belongsTo(PieceType::class,'piece_type_id');
    }

}
