<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class City extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable =['city'];

    public function user()
    {
        return $this->hasMany(User::class)->withTrashed();
    }

    public function company()
    {
        return $this->hasMany(Company::class)->withTrashed();
    }

    public function garage()
    {
        return $this->hasMany(Garage::class)->withTrashed();
    }

    public function city()
    {
        return $this->hasMany(City::class);
    }

}
