<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Call extends Model
{
    use HasFactory;

    protected $fillable =[
        'name',
        'user_id',
        'session_id',
        'dossier_id'
    ];

    public function user()
    {
       return $this->belongsTo(User::class);
    }
    
    public function dossier()
    {
        return $this->belongsTo(Dossier::class);
    }
}
