<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class HandleApiToken
{
    public function handle(Request $request, Closure $next)
    {
        // If Authorization header is missing, check for X-Auth-Token
        if (!$request->bearerToken() && $request->header('X-Auth-Token')) {
            $token = $request->header('X-Auth-Token');
            $request->headers->set('Authorization', 'Bearer ' . $token);
        }
        
        return $next($request);
    }
}
