<?php

namespace App\Http\Controllers;

use App\Models\Calculator;
use App\Models\Carburant;
use App\Models\Category;
use App\Models\Dossier;
use App\Models\Etat;
use App\Models\Kilometrage;
use App\Models\Marketvalue;
use App\Models\Pf;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class MarketvalueController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {
        $this->authorize('create', Marketvalue::class);
        $dossier = Dossier::whereId($id)->first();
        $user = User::whereId(Auth::user()->id)->first();
        $pfs = Pf::all();
        $categories = Category::all();
        $etats = Etat::all();
        $carburants = Carburant::all();
        return view('configuration.venale.create', compact('pfs', 'categories', 'etats', 'carburants', 'dossier'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // $this->authorize('create', Marketvalue::class);
        // $this->validate($request, [
        //     'startdate' => 'required|date',
        //     'enddate' => 'required|date|after:startdate',

        // ]);
        $startDate = Carbon::parse($request->startdate);
        $endDate = Carbon::parse($request->enddate);
        $diff = $startDate->diffInMonths($endDate);

        $calculyears = $diff / 12;
        $years = (int)$calculyears;
        $months = $diff % 12;
        $price = $request->valeur;

        $array = [];
        $calcul = [];


        if ($request->pu <= 7 && $request->pu > 0) {
            $d = Calculator::where('category_id', $request->input('categorie'))
                ->where('pf_id', 1)
                ->where('carburant_id', $request->carburant)
                ->get();
        } else if ($request->pu < 12 && $request->pu >= 8) {
            $d = Calculator::where('category_id', $request->input('categorie'))
                ->where('pf_id', 2)
                ->where('carburant_id', $request->carburant)
                ->get();
        } else if ($request->pu >= 12) {

            $d = Calculator::where('category_id', $request->input('categorie'))
                ->where('pf_id', 3)
                ->where('carburant_id', $request->carburant)
                ->get();
        }
        foreach ($d as $a) {
            array_push($array, $a->pourcentage);
        }
        if ($years == 0) {
            $pourcetage = $array[$years] / 12;
            $pourcentagemonths = $pourcetage * $months;
            $price = $price - $price * ($pourcentagemonths / 100);
        }
        if ($years < 5 && $years > 0) {

            for ($i = 0; $i < $years - 1; $i++) {

                $price = $price - $price * ($array[$i] / 100);
            }

            if ($months > 0) {

                $pourcetage = $array[$years] / 12;
                $pourcentagemonths = $pourcetage * $months;
                $price = $price - $price * ($pourcentagemonths / 100);
            }

            /* dd($price); */
        } elseif ($years >= 5 && $years < 10) {

            for ($i = 0; $i < 4; $i++) {

                $price = $price - $price  * ($array[$i] / 100);
            }

            for ($i = 4; $i < $years; $i++) {

                $price = $price - $price * (10 / 100);
            }
            if ($months > 0) {

                if ($years < 10) {

                    $pourcentage = 10 / 12;
                    $pourcentagemonths = $pourcentage * $months;

                    $price = $price - $price * ($pourcentagemonths / 100);
                }

                if ($years == 10) {

                    $price = $price - $price * (10 / 100);
                }
                /* dd($price); */
            }
        } elseif ($years >= 10) {
            for ($i = 0; $i < 4; $i++) {

                $price = $price - $price  * ($array[$i] / 100);
            }

            for ($i = 5; $i < 10; $i++) {

                $price = $price - $price * (10 / 100);
            }

            for ($i = 11; $i < $years - 1; $i++) {

                $price = $price - $price * (5 / 100);
            }
            if ($months > 0) {

                if ($years < 10) {

                    $pourcentage = 5 / 12;
                    $pourcentagemonths = $pourcentage * $months;

                    $price = $price - $price * ($pourcentagemonths / 100);
                }

                if ($years == 10) {

                    $price = $price - $price * (5 / 100);
                }
            }
        }

        /* IF Kilometrage */
        $km = Kilometrage::where('pf_id', $request->pfiscale)
            ->where('carburant_id', $request->carburant)
            ->first();
        if ($years == 0) {
            $yearscompt = $request->input('compteur');
        } elseif ($years > 0) {
            $yearscompt = $request->input('compteur') / $years;
        }
        $yearskm = $km->km - $yearscompt;

        $total = $yearskm / 1000;

        $totalall = $total * 0.5;

        $totalpricekm = $price  * ($totalall / 100);

        $totalallth = $price + $totalpricekm;
        $formatted_number = number_format((float)$totalallth, 2, '.', '');
        $formatted_number2 = number_format((float)$price, 2, '.', '');

        return [$formatted_number2, $formatted_number];

    }


    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Marketvalue  $marketvalue
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $marketvalue = Marketvalue::whereId($id)->with('dossier')->firstOrFail();
        return view('configuration.venale.show', compact('marketvalue'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Marketvalue  $marketvalue
     * @return \Illuminate\Http\Response
     */
    public function edit(Marketvalue $marketvalue)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Marketvalue  $marketvalue
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Marketvalue $marketvalue)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Marketvalue  $marketvalue
     * @return \Illuminate\Http\Response
     */
    public function destroy(Marketvalue $marketvalue)
    {
        //
    }
}
